<?php
/**
 * API Route Tanımları
 */
return function (Router $router) {

    // ── Public Routes (Auth gerektirmez) ──
    $router->group('/api', ['RateLimitMiddleware'], function (Router $r) {

        // Auth
        $r->post('/auth/register', 'AuthController@register');
        $r->post('/auth/login', 'AuthController@login');
        $r->post('/auth/refresh', 'AuthController@refresh');

        // Public kitap listesi
        $r->get('/books', 'BookController@index');
        $r->get('/books/{slug}', 'BookController@show');
    });

    // ── Authenticated Routes ──
    $router->group('/api', ['RateLimitMiddleware', 'AuthMiddleware'], function (Router $r) {

        // Auth
        $r->post('/auth/logout', 'AuthController@logout');
        $r->get('/me', 'AuthController@me');

        // Kitap erişim & içerik
        $r->get('/books/{id}/access', 'BookController@access');
        $r->get('/books/{id}/chunks', 'BookController@chunkIndex');
        $r->get('/books/{id}/chunk/{chunkNo}', 'BookController@chunk');
        $r->get('/books/{id}/download', 'BookController@download');

        // Abonelik
        $r->post('/subscription/verify', 'SubscriptionController@verify');
        $r->get('/me/entitlement', 'SubscriptionController@entitlement');

        // Okuma ilerleme
        $r->post('/progress/update', 'ProgressController@update');
        $r->get('/progress', 'ProgressController@show');

        // Yer imleri
        $r->get('/bookmarks', 'BookmarkController@index');
        $r->post('/bookmarks', 'BookmarkController@store');
        $r->delete('/bookmarks/{id}', 'BookmarkController@destroy');
    });

    // ── Admin Routes ──
    $router->group('/api/admin', ['RateLimitMiddleware', 'AuthMiddleware', 'AdminMiddleware'], function (Router $r) {

        // Dashboard
        $r->get('/dashboard', 'AdminController@dashboard');

        // Kitap yönetimi
        $r->get('/books', 'AdminBookController@index');
        $r->post('/books', 'AdminBookController@store');
        $r->get('/books/{id}', 'AdminBookController@show');
        $r->put('/books/{id}', 'AdminBookController@update');
        $r->delete('/books/{id}', 'AdminBookController@destroy');

        // Çeviri yönetimi
        $r->get('/books/{id}/translations', 'AdminBookController@translations');
        $r->post('/books/{id}/translations', 'AdminBookController@addTranslation');
        $r->put('/translations/{id}', 'AdminBookController@updateTranslation');

        // Asset yönetimi (chunk/epub/pdf yükleme)
        $r->get('/books/{id}/assets', 'AdminAssetController@index');
        $r->post('/books/{id}/assets/upload', 'AdminAssetController@upload');
        $r->delete('/assets/{id}', 'AdminAssetController@destroy');

        // Chunk yönetimi
        $r->post('/books/{id}/chunks/upload', 'AdminAssetController@uploadChunks');

        // Kullanıcı yönetimi
        $r->get('/users', 'AdminUserController@index');
        $r->get('/users/{id}', 'AdminUserController@show');
        $r->put('/users/{id}/roles', 'AdminUserController@updateRoles');

        // Raporlar
        $r->get('/reports/subscriptions', 'AdminController@subscriptionReport');
        $r->get('/reports/popular-books', 'AdminController@popularBooksReport');
    });
};
