<?php
/**
 * Auth Middleware - JWT token doğrulama
 * Geçerli kullanıcıyı global $currentUser'a atar
 */
class AuthMiddleware
{
    public function handle(): bool
    {
        global $currentUser;

        $token = Request::bearerToken();
        if (!$token) {
            Response::error('Kimlik doğrulama gerekli', 'AUTH_REQUIRED', 401);
            return false;
        }

        $payload = JWT::verify($token, 'access');
        if (!$payload) {
            Response::error('Token geçersiz veya süresi dolmuş', 'TOKEN_INVALID', 401);
            return false;
        }

        // Kullanıcıyı DB'den doğrula
        $user = Database::fetch(
            'SELECT id, email, name, locale FROM users WHERE id = ?',
            [$payload['sub']]
        );

        if (!$user) {
            Response::error('Kullanıcı bulunamadı', 'USER_NOT_FOUND', 401);
            return false;
        }

        $currentUser = $user;
        $currentUser['roles'] = self::getUserRoles($user['id']);
        return true;
    }

    private static function getUserRoles(int $userId): array
    {
        $rows = Database::fetchAll(
            'SELECT r.name FROM roles r
             INNER JOIN user_roles ur ON ur.role_id = r.id
             WHERE ur.user_id = ?',
            [$userId]
        );
        return array_column($rows, 'name');
    }
}
