<?php
/**
 * Admin Middleware - Admin rolü kontrolü
 * AuthMiddleware'den sonra çalışmalıdır
 */
class AdminMiddleware
{
    public function handle(): bool
    {
        global $currentUser;

        if (!$currentUser) {
            Response::error('Kimlik doğrulama gerekli', 'AUTH_REQUIRED', 401);
            return false;
        }

        $adminRoles = ['superAdmin', 'admin', 'editor'];
        $hasAccess = !empty(array_intersect($currentUser['roles'], $adminRoles));

        if (!$hasAccess) {
            Response::error('Bu işlem için yetkiniz yok', 'FORBIDDEN', 403);
            return false;
        }

        return true;
    }
}
