<?php
/**
 * Bookmark Controller - Yer imi yönetimi
 */
class BookmarkController
{
    /**
     * GET /api/bookmarks?bookId=...&lang=...
     */
    public function index(array $params): void
    {
        global $currentUser;

        $bookId = Request::queryInt('bookId', 0);
        $lang   = Request::query('lang', 'tr');

        if ($bookId > 0) {
            $bookmarks = Database::fetchAll(
                'SELECT id, book_id, lang, page, location, label, color, created_at
                 FROM bookmarks
                 WHERE user_id = ? AND book_id = ? AND lang = ?
                 ORDER BY page ASC, created_at ASC',
                [$currentUser['id'], $bookId, $lang]
            );
        } else {
            $bookmarks = Database::fetchAll(
                'SELECT bm.*, bt.title as book_title, b.slug as book_slug
                 FROM bookmarks bm
                 INNER JOIN books b ON b.id = bm.book_id
                 LEFT JOIN book_translations bt ON bt.book_id = bm.book_id AND bt.lang = bm.lang
                 WHERE bm.user_id = ?
                 ORDER BY bm.created_at DESC',
                [$currentUser['id']]
            );
        }

        Response::success($bookmarks);
    }

    /**
     * POST /api/bookmarks
     */
    public function store(array $params): void
    {
        global $currentUser;

        $data = Request::validate(['bookId']);

        $bookId   = (int)$data['bookId'];
        $lang     = Request::input('lang', 'tr');
        $page     = Request::input('page');
        $location = Request::input('location');
        $label    = Request::input('label', '');
        $color    = Request::input('color', '#FFD700');

        // Kitap var mı?
        $book = Database::fetch('SELECT id FROM books WHERE id = ?', [$bookId]);
        if (!$book) {
            Response::error('Kitap bulunamadı', 'BOOK_NOT_FOUND', 404);
        }

        $id = Database::insert(
            'INSERT INTO bookmarks (user_id, book_id, lang, page, location, label, color)
             VALUES (?, ?, ?, ?, ?, ?, ?)',
            [$currentUser['id'], $bookId, $lang, $page, $location, $label, $color]
        );

        Response::success([
            'id'     => (int)$id,
            'bookId' => $bookId,
            'page'   => $page,
            'label'  => $label,
        ], 'Yer imi eklendi', 201);
    }

    /**
     * DELETE /api/bookmarks/{id}
     */
    public function destroy(array $params): void
    {
        global $currentUser;

        $id = (int)$params['id'];

        $affected = Database::execute(
            'DELETE FROM bookmarks WHERE id = ? AND user_id = ?',
            [$id, $currentUser['id']]
        );

        if ($affected === 0) {
            Response::error('Yer imi bulunamadı', 'BOOKMARK_NOT_FOUND', 404);
        }

        Response::success(null, 'Yer imi silindi');
    }
}
