<?php
/**
 * Admin Controller - Dashboard ve raporlar
 */
class AdminController
{
    /**
     * GET /api/admin/dashboard
     */
    public function dashboard(array $params): void
    {
        $totalUsers = Database::fetch('SELECT COUNT(*) as c FROM users')['c'];
        $totalBooks = Database::fetch('SELECT COUNT(*) as c FROM books')['c'];
        $publishedBooks = Database::fetch("SELECT COUNT(*) as c FROM books WHERE status = 'published'")['c'];
        $activeSubscriptions = Database::fetch('SELECT COUNT(*) as c FROM subscriptions WHERE is_active = 1 AND expiry_time > NOW()')['c'];

        $recentUsers = Database::fetchAll(
            'SELECT id, email, name, created_at FROM users ORDER BY created_at DESC LIMIT 5'
        );

        $popularBooks = Database::fetchAll(
            'SELECT b.id, b.slug, b.view_count, bt.title
             FROM books b
             LEFT JOIN book_translations bt ON bt.book_id = b.id AND bt.lang = b.default_lang
             ORDER BY b.view_count DESC LIMIT 10'
        );

        $readingStats = Database::fetch(
            'SELECT COUNT(DISTINCT user_id) as active_readers,
                    SUM(total_reading_time) as total_time
             FROM reading_progress
             WHERE updated_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)'
        );

        Response::success([
            'stats' => [
                'totalUsers'          => (int)$totalUsers,
                'totalBooks'          => (int)$totalBooks,
                'publishedBooks'      => (int)$publishedBooks,
                'activeSubscriptions' => (int)$activeSubscriptions,
                'activeReaders30d'    => (int)($readingStats['active_readers'] ?? 0),
            ],
            'recentUsers'  => $recentUsers,
            'popularBooks' => $popularBooks,
        ]);
    }

    /**
     * GET /api/admin/reports/subscriptions
     */
    public function subscriptionReport(array $params): void
    {
        $monthly = Database::fetchAll(
            "SELECT DATE_FORMAT(created_at, '%Y-%m') as month,
                    COUNT(*) as total,
                    SUM(is_active) as active
             FROM subscriptions
             GROUP BY month
             ORDER BY month DESC
             LIMIT 12"
        );

        $byProduct = Database::fetchAll(
            'SELECT product_id, COUNT(*) as total, SUM(is_active) as active
             FROM subscriptions GROUP BY product_id'
        );

        $expiringSoon = Database::fetchAll(
            'SELECT s.*, u.email, u.name
             FROM subscriptions s
             INNER JOIN users u ON u.id = s.user_id
             WHERE s.is_active = 1 AND s.expiry_time BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 7 DAY)
             ORDER BY s.expiry_time ASC'
        );

        Response::success([
            'monthly'       => $monthly,
            'byProduct'     => $byProduct,
            'expiringCount' => count($expiringSoon),
            'expiringSoon'  => $expiringSoon,
        ]);
    }

    /**
     * GET /api/admin/reports/popular-books
     */
    public function popularBooksReport(array $params): void
    {
        $lang = Request::query('lang', 'tr');

        $popular = Database::fetchAll(
            'SELECT b.id, b.slug, b.view_count, b.is_free, b.total_pages,
                    bt.title, bt.author,
                    COUNT(DISTINCT rp.user_id) as readers,
                    AVG(rp.progress_percent) as avg_progress
             FROM books b
             LEFT JOIN book_translations bt ON bt.book_id = b.id AND bt.lang = ?
             LEFT JOIN reading_progress rp ON rp.book_id = b.id
             WHERE b.status = ?
             GROUP BY b.id
             ORDER BY readers DESC, b.view_count DESC
             LIMIT 20',
            [$lang, 'published']
        );

        Response::success($popular);
    }
}
