<?php
/**
 * Uygulama Konfigürasyonu
 * Domain: ekitap.2w.tr
 */
return [
    'name'        => 'E-Kitap API',
    'version'     => '1.0.0',
    'debug'       => getenv('APP_DEBUG') === 'true',
    'base_url'    => getenv('APP_URL') ?: 'https://ekitap.2w.tr',
    'storage_path'=> dirname(__DIR__, 2) . '/storage',

    // JWT Ayarları
    'jwt' => [
        'secret'          => getenv('JWT_SECRET') ?: 'X9kP2mL7vR4nQ8wJ3tF6yB0hD5sA1cE8gU2iN7oK4rW9xZ3bM6jT0pV5qH1lY8f',
        'access_ttl'      => 3600,        // 1 saat
        'refresh_ttl'     => 2592000,     // 30 gün
        'algorithm'       => 'HS256',
    ],

    // Google Play Billing
    'google_play' => [
        'package_name'       => getenv('GOOGLE_PACKAGE') ?: 'com.ekitap.app',
        'service_account_json'=> dirname(__DIR__) . '/config/google-service-account.json',
    ],

    // Rate Limiting
    'rate_limit' => [
        'requests_per_minute' => 60,
    ],

    // Desteklenen diller
    'supported_languages' => ['tr', 'en', 'de', 'es', 'fr', 'it', 'pt', 'ar'],
    'default_language'    => 'tr',

    // Sayfalama
    'pagination' => [
        'default_limit' => 20,
        'max_limit'     => 100,
    ],

    // Cache süreleri (saniye)
    'cache' => [
        'covers'      => 604800,  // 7 gün
        'chunk_index' => 3600,    // 1 saat
        'chunk_content'=> 86400,  // 1 gün
    ],
];
