<?php
/**
 * E-Kitap API - Ana Giriş Noktası
 * Tüm API istekleri .htaccess ile bu dosyaya yönlendirilir
 */

// Hata raporlama - JSON formatında hata döndür
error_reporting(E_ALL);
ini_set('display_errors', '0');
ini_set('log_errors', '1');

// Tüm hataları yakala ve JSON olarak döndür
set_exception_handler(function (Throwable $e) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'error' => [
            'code' => 'INTERNAL_ERROR',
            'message' => 'Sunucu hatası: ' . $e->getMessage(),
            'file' => basename($e->getFile()),
            'line' => $e->getLine()
        ]
    ], JSON_UNESCAPED_UNICODE);
    exit;
});

set_error_handler(function ($severity, $message, $file, $line) {
    throw new ErrorException($message, 0, $severity, $file, $line);
});

// Timezone
date_default_timezone_set('Europe/Istanbul');

// Backend dizini
$backendDir = dirname(__DIR__); // backend/ dizini

// .env dosyasını yükle (Composer kullanılmadığı için manuel)
$envFile = $backendDir . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (str_starts_with(trim($line), '#')) continue;
        if (strpos($line, '=') === false) continue;
        [$key, $value] = explode('=', $line, 2);
        $key = trim($key);
        $value = trim($value);
        if (!getenv($key)) {
            putenv("{$key}={$value}");
            $_ENV[$key] = $value;
        }
    }
}

// CORS Headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Max-Age: 86400');

// OPTIONS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

// Content-Type JSON olarak ayarla (varsayılan)
header('Content-Type: application/json; charset=utf-8');

// Autoloader
spl_autoload_register(function (string $class) use ($backendDir) {
    $directories = [
        $backendDir . '/core/',
        $backendDir . '/middleware/',
        $backendDir . '/controllers/',
        $backendDir . '/models/',
    ];

    foreach ($directories as $dir) {
        $file = $dir . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Router oluştur ve route'ları yükle
$router = new Router();
$registerRoutes = require $backendDir . '/routes/api.php';
$registerRoutes($router);

// URI'yi belirle
$uri = $_SERVER['REQUEST_URI'] ?? '/';

// Query string'i kaldır (Router'da da yapılıyor ama güvenlik için burada da)
$uri = strtok($uri, '?');

// Dispatch
$router->dispatch(
    $_SERVER['REQUEST_METHOD'],
    $uri
);
